function [maxCondNo,CPUsecond,fSigma,hValError,maxNormOFx,maxSing,maxPower,minSing,mindSigmaRatio,normOFdx,normOFx,...
			normOFpDirect,predIteration,statusP,totalCorrIteration,xSigmaCurrent] ... 
			= traceOneCurve2(coeffMatrix,informationLevel,kcell,nDim,noTermsVect,noteFileName,numOfInitPoints,...
				outputHeadName,parameter,powerMatrix,pthInitPoint,statFileName,xSigma0Vect);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%	A mojor function of CMPSm (MATLAB)
%	Version 1.0 January, 2002
%   Vestion 1.1 October 26, 2002
%   Version 1.2 December 31, 2002
%   Version 2.0 Janurary 13, 2003
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%	coefficientMatrix 
%		---	Each coefficientMatrix{jthrow} contains the coefficients of 
%			all the terms in the jth homotopy equation;
%			coefficientMatrix{jthrow}(1,kthterm) denotes the 
%			coefficient of the kthterm of the jthrow equation.
%	nDim --- the dimension of the polynomial system
%	noTermsVect 
%		--- 1 x nDim.
%			noTermsVect(1,jthrow) denotes the number of terms 
%			involved in the jth homotopy equation
%	noteFileName --- additional inforamtion on the numerical computaion of the homotopy 
%					curves will be written 
%	numOfInitPoints
%		---	the number of initial points in a mixed-cell of Dai's input file
%	outputHeadName 
%		--- the name of the cluster consisting of cells 
%	parameter
%		--- major parameters specified in the paraFile
%	powerMatrix
%		--- Each powerMatrix{jthrow}(kthterm,:) contains the 
%			nDim+1 power vector of the kthterm of the jthrow 
%			equation.
%	pthInitPoint
%		--- the pth initial point from Dai's input file 
%	xSigma0Vect 
%		--- The initial point, an (nDim+1) \times 1 vector.
%			Note that the last coordinate xSigmaVect(nDim+1,1) = sigma0 =
%			-20.0
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

startingTime = cputime; 
sigma0 = xSigma0Vect(nDim+1,1); 

% horizontalSW = 0;

%%% a parameter on scaling of function values and columns of the Jacobian matrix
scalingSW = 4;
	% = 0	--- no scaling
	% = 1	--- row scaling
	% = 2	--- row and column scaling
    % = 3   --- new row and column scaling
    % = 4   --- scalingSW 3 + new row scaling directly applied to system of linear equations
%%% parameters to choose the first or second order predictor 
predOrder = 2;
	% = 1	--- the first order predictor ---> 
	% = 2	---	the second order predictor
% dSigmaPredOrder = 5.0e-10; % if dSigma < dSigmaPredOrder then predOrder = 1 
%%% <--- parameters to choose the first or second order predictor 

%%% parameters on displaying iteration information ---> 
% informationLevel = 0;
%		=  0	--- no information on each iteration
% 		=  1	--- some additional information on each iteration on .note
% 		            file
howOften = 1;
%%% <--- parameters on displaying iteration information

%%% parameters given in the main function ---> 
accINfVal = parameter.accINfVal; % default accINfVal= 1.0e-10; 
	% the infinity norm accuracy in the function value at an approximate 
	% solution to be computed
accInNewtonDir = parameter.accInNewtonDir; % defaule accInNewtonDir= 1.0e-8
	% the 2-norm tolerance in terms of the Newton direction at an approx. solution
	% When the norm of the Newton direction gets smaller than accInNewtonDir,
	% stop the corrector iteration for the final solution of the 
	% target polynomial system. 
divMagOFx = parameter.divMagOFx; % default divMagOFx= 1.0e2 for cyclic problems 
	% "divMagOFx <= the infinity norm of the current point x" 
	% is necessary to judge the divergence 
NewtonDirMax = parameter.NewtonDirMax; % default NewtonDirMax = 0.1
	% When the norm of the first Newton iterate exceeds the value 
	% NewtonDirMax \times "the norm of x", we abandan the corrector procedure 
dSigmaRatioMax = min([parameter.dTauMax * exp(1) / (1+parameter.dTauMax * exp(1)),0.9]); 
	% the upper bound for the predictor step length in the sigma space; 
    % dSigma / (-sigma) \leq dSigmaSigmaRatioMax
    % e.g., dSigmaSigmaRatioMax = 0.5
minSingForNonsing = sqrt(parameter.minEigForNonsing); % 1.0e-12; 
predItMax = parameter.predItMax; % upper bound for predictor iterations
%%% <--- parameters given in the main function 

extSmallNumber = 1.0e-50; 
	% Used for the numerical stability in computing the Newton direction

%%% parameters to control the predictor procedure ---> 
angleMin = 0.90; % default angleMin = 0.90	
	% If the angle between the previous and the current predictor directions  
	% in the x-space becomes less than angleMin, abandon the current iterate
	% and retry the predictor procedure from the previous iterate. 
angleThDown = 0.95; % default angleThDown = 0.95
	% When the angle between the previous and the current predictor direction
	% in the x-space gets smaller than angleThDown, we try to keep the current 
	% predictor step lenght predStep. 
% dTauMin = 1.0e-16; % defaule dTauMin = 1.0e-18
	% Lower bound for the predictor step length in the tauRef space; 
	% When dTau gets smaller than dTauMin, we stop the predictor iteration and abondon the computation. 
	% the initial predictor step length in the tauRef space. 
expansionFactor = 1.414;
	% the expansion factor of predictor step lengths 
reductionFactor = 0.707;
	% the reduction factor of predictor step lengths 
dSigmaRatioMin = 1.0e-12;
	% the lower bound for the predictor step length in the sigma space; 
    % if the inequality dSigma / (-sigma) \geq dSigmaSigmaRatioMin is violated then stop. 
%%% <--- parameters to control the predictor procedure

%%% parameters to control the corrector procedure ---> 
cITthreshold = 2; 
corrItMax = 10;
ctMax = 0.90; 
ctThreshold = 0.1;
distMin = 1.0e-7; % default distMin = 1.0e-7
	% when the norm of the Newton direction gets smaller than distMin,
	% stop the corrector iteration.  
	% These two values above are multiplied by
	% the norm of the initial iterate of the corrector procedure 
	% before starting the corrector procedure, namely, 
	% NewtonDirMax = NewtonDirMax * normOFx and 
	% distThreshold = distThreshold * normOFx,  
%	% where normOFx = max([norm(xSigmaCurrent(1:nDim,1),inf),1]). 
	% where normOFx = max([norm(xSigmaCurrent(1:nDim,1)),1]). 
distThreshold = NewtonDirMax * 1.0e-1; 
	% When the norm of the first Newton iterate exceeds the value 
	% NewtonDirMax x ''the norm of x'', we abandan the corrector procedure 
hValAccuracy = 1.0e-7; % default hValAccuracy = 1.0e-7	
	% the accuarcy for the homotopy function value, a stopping criteria in the corrector procedure 
	% When the infinity norm of the homotopy function value gets smaller than hValAccuracy, 
	% stop the corrector iteration. 
%%% <--- parameters to control the corrector procedure

%%% parameters to detect the convergence or the divergence ---> 
sigmaEqualTo0 = -1.0e-16; % default sigmaEqualTo0 = -1.0e-7
    % When sigmaEqualTo0 \leq maxPower * sigma, terminate after checking the convergence.  
sigmaValIntoNewton = -1.0e-10; % default sigmaValIntoNewton = -1.0e-4
    % When sigmaValIntoNewton \leq maxPower * sigma, start checking the convergence.
%%% <--- parameters to detect the convergence or the divergence 

[maxPower,totalNoTerms,tPowerVector] = pre4Processing(nDim,noTermsVect,powerMatrix); 
	% tPowerVector	---	the vector of powers of t. 	
	% totalNoTerms	--- the length of tPowerVector.
	% maxPower = max(tPowerVector).
	% These are used to determine the predictor step length in the sigma space. 

[maxPower,totalNoTerms,tPowerAndTheirLog] = ...
    preProcessTpower(nDim,noTermsVect,powerMatrix); 

%%% for efficient MATLAB computation of function and Jacobian matrix value ---> 
[lenPowColVector,powerColVector,coeffColVector,assembleMatrix] = ...
	prepFunctEval(nDim,noTermsVect,coeffMatrix,powerMatrix);
[powerJMatrix,coeffJMatrix] = ...
	prepJMatrixEval(nDim,noTermsVect,lenPowColVector,powerColVector);
%%% These two functions reduce the CPU time about 1/20 times compared to 
%%% a standard implementation. 
%%% <--- for efficient MATLAB computation of function and Jacobian matrix value 

%%% initilization ---> 
predOrder0 = predOrder;

sigmaOld = sigma0;
sigmaCurrent = sigma0; 

dSigmaRatioCurrent = dSigmaRatioMax * 0.5;
mindSigmaRatio = dSigmaRatioMax * 0.5;

xSigmaOld = xSigma0Vect; 	
xSigmaCurrent = xSigmaOld; 
	% set the initial point (x,t) \in C^n \times [0,1]
theta = 1.0; 
% condGMat = 1.0; 
% normOFx = norm(xSigmaOld(1:nDim,1),inf); 
normOFx = norm(xSigmaOld(1:nDim,1)); 
maxNormOFx = normOFx; 
	% set the infinity norm of x
finalSW = 0; 
[hValOld,rowScaling] = ...
hFunctVect(nDim,noTermsVect,lenPowColVector,powerColVector,coeffColVector,...
    assembleMatrix,xSigmaCurrent,scalingSW,finalSW); 
hValCurrent = hValOld; 
hValError = norm(hValCurrent,inf);
	% the infinity norm of the homotopy function value hValOld
[DhMatrix,colScaling,JacobScaling] = ...
JacobianMatrix(nDim,noTermsVect,lenPowColVector,coeffColVector,assembleMatrix,powerJMatrix,coeffJMatrix,...
    xSigmaCurrent,scalingSW,rowScaling,finalSW); 
	% the Jacobian matrix of the homotopy function w.r.t. (x,t) \in C^n \times [0,1]
%%%%% Solving the Newton equation by svd factorization ---> 
normRightHand = norm(DhMatrix(:,nDim+1)); 
% Kojima 2003/02/22 --->
% To place all real and complex nonzero elements into DhMatrix(:,1:nDim)
% This is necessary to use svd in MATLAB version 5.2
	DhMatrix(:,1:nDim) = DhMatrix(:,1:nDim) + extSmallNumber * rand(nDim,nDim) * (rand(1,1)+i);
% <--- Kojima 2003/02/22
[UMat,SMat,VMat] = svd(DhMatrix(:,1:nDim)); 
	% small perturbation to ensure the nonsingularity of SMat
SVect = max(diag(SMat), min(extSmallNumber,normRightHand) * ones(nDim,1)); 
pDirect0 = [-(VMat * ((UMat' * DhMatrix(:,nDim+1)) ./ SVect)); 1.0];
%%%%% <--- Solving the Newton equation by svd factorization 
minSing = (min(abs(diag(SMat)'))); 
maxSing = (max(abs(diag(SMat)'))); 
% Kojima 2002/12/31 ---> 
maxCondNo = maxSing/minSing; 
% <--- Kojima 2002/12/31 
if scalingSW >= 2
	pDirect0(1:nDim,1) = pDirect0(1:nDim,1) ./ colScaling'; 
end

pDirect1 = pDirect0;
pDirect2 = pDirect1; 
	% the predictor direction in the space C^n \times R.
	% storing the current predictor direction for a possible case 
	% when the current predictor procedure with pDirect fails. 
normOFpDirect = norm(pDirect1(1:nDim,1)); 
statusP = 0;
	% the status of the predictor procedure;
	% =  0 	---	continue
	% = -1	--- fail; too small predictor step length
	% = -2  --- diverge
	% = -3  --- fail; predIteration > predItMax
    % = -4  --- faile; too large magnitude of the iterate
	% =  3	--- success, convergence to a nonsingular solution in the final 
	%			Newton procedure 
	% =  4	--- success, convergence to a singular solution in the final 
	%			Newton procedure
    % =  5  --- fail; probably either divergence, convergence to
    %           a singular solution in the final Newton iteration
predIteration = 0;
	% the counter for the predictor iterations.
totalCorrIteration = 0; 
	% the counter for the total corrector iterations. 
statusC = 0;
	% the status of the corrector procedure;
	% = 0 	---	continue.
	% <= -1	--- abandon the current corrector procedure 
	%			and retry the predictor procedure with the half predictor step length.
	% = 1	--- success and try to keep the current predictor step length
	% >= 2	---	success and try to increase the current predictor step length 
	%			in the next predictor iteration.
oldStatusC = -1; 
corrIteration = 0;
	% the counter for the corrector iterations between two consecutive
	% predictor iteations.
angleSW = 0;
	% Computation of the angle -1 <= theta <= 1 between the previous 
	% and the new predictor directions is done only when angleSW = 1.
	% Initially angleSW is set to be 0.
singularSW = 0; 
%%%%% <--- initialization

%%%%% Kojima 2001/11/19 ---> 
if informationLevel == 1
	noteFID = fopen(noteFileName,'a');
	writeHeadderName(noteFID,kcell,numOfInitPoints,outputHeadName,pthInitPoint); 
	writeHeadderInformation(noteFID); 
	writeIterationInformation(noteFID,angleSW,statusC,nDim,predIteration,...
		xSigmaCurrent,hValError,normOFx,dSigmaRatioCurrent,corrIteration,minSing,maxSing,theta);
	fclose(noteFID); 
end
% return; 
%%%%% Kojima <--- 2001/11/19 

%%%%% main loop ---> 
while (0 <= statusP) & (statusP <=1)  
	predIteration = predIteration + 1;
%%%%% Kojima 2001/11/11 --->
	if angleSW==0
		predOrder = 1;
	else
		predOrder = predOrder0;
	end
    dSigma = (-sigmaCurrent) * dSigmaRatioCurrent; 
	sigmaPredicted = sigmaCurrent + dSigma; 
    %%%%% Checking divergence; kojima2003/01/16 --->
    if maxPower * sigmaCurrent >= 10*sigmaValIntoNewton
        lambda = min([(maxPower * sigmaCurrent - 10*sigmaValIntoNewton) / (sigmaValIntoNewton - 10*sigmaValIntoNewton), 1.0]); 
        divMagOFx1 = (lambda + (1-lambda) *100.0) * divMagOFx; 
        if divMagOFx1 <= normOFx
            fSigma = xSigmaCurrent(nDim+1,1); 
            statusP = -2; 
        end
%%%%%%%%%% kojima 2003/03/04 ---> 
    elseif (maxPower * sigmaCurrent >= -1.0e-3) & (normOFx >= 1.0e6) 
        statusP = -2; 
        fSigma = xSigmaCurrent(nDim+1,1); 
%%%%%%%%%% <--- kojima 2003/03/04  
    end
    %%%%% <--- Checking divergence; kojima2003/01/16
    %%%%% Final checking convergence or divergence %%%%% 
%%%%%%%%%% kojima 2003/01/16 ---> 
%   if (sigmaEqualTo0 < maxPower * sigmaPredicted)  | (dSigmaRatioCurrent < dSigmaRatioMin) 
%%%%%%%%%% <---
   if ((statusP == 0) | (statusP == 1)) & ...
   ( (sigmaEqualTo0 < maxPower * sigmaCurrent)  | (dSigmaRatioCurrent < dSigmaRatioMin) )
        fSigma = xSigmaCurrent(nDim+1,1); 
% Kojima 2003/01/16 --->         
%        if (sigmaValIntoNewton < maxPower * sigmaPredicted) & (divMagOFx < normOFx) 
%            statusP = -2; 
%        else
% <--- Kojima 2003/01/16 
            xSigmaPredicted0 = zeros(nDim+1,1); 	
%			if 1 == 1% predOrder == 1
    		xSigmaPredicted0(1:nDim,1) = xSigmaCurrent(1:nDim,1) + (-sigmaCurrent) * pDirect1(1:nDim,1);
%            else % (predOrder == 2) 
%			    secondOrderTerm = 0.5*(-sigmaCurrent)*((-sigmaCurrent) /(xSigmaCurrent(nDim+1,1)-xSigmaOld(nDim+1,1)))...
%				    *(pDirect1(1:nDim,1)-pDirect0(1:nDim,1)); 
%			    xSigmaPredicted0(1:nDim,1) = xSigmaCurrent(1:nDim,1)+(-sigmaCurrent)*pDirect1(1:nDim,1)+secondOrderTerm;
%            end
            finalSW = 1; 
  			[hValPredicted0,rowScaling] = ...
				hFunctVect(nDim,noTermsVect,lenPowColVector,powerColVector,coeffColVector,assembleMatrix,xSigmaPredicted0,scalingSW,finalSW);
            hValError0 = norm(hValPredicted0,inf);
            xSigmaPredicted1 = zeros(nDim+1,1);
 			xSigmaPredicted1(1:nDim,1) = xSigmaCurrent(1:nDim,1); 
  			[hValPredicted1,rowScaling1] = ...
				hFunctVect(nDim,noTermsVect,lenPowColVector,powerColVector,coeffColVector,assembleMatrix,xSigmaPredicted1,scalingSW,finalSW);
            hValError1 = norm(hValPredicted1,inf);
            if hValError1 < hValError0 
                xSigmaPredicted0 = xSigmaPredicted1; 
                hValPredicted0 = hValPredicted1; 
                hValError0 = hValError1;
                rowScaling = rowScaling1; 
            end; 
            finalSW = 1; 
    		[statusC,corrIteration,xSigmaPredicted,hValPredicted,hValError,rowScaling,colScaling]  ... 
    				= cProced(finalSW,accINfVal,accInNewtonDir,nDim,noTermsVect,powerJMatrix,coeffJMatrix,lenPowColVector,powerColVector,...
    					coeffColVector,assembleMatrix,xSigmaPredicted0,hValPredicted0,...
    					NewtonDirMax,distThreshold,ctMax,ctThreshold,corrItMax,scalingSW,rowScaling,colScaling); 
            totalCorrIteration = totalCorrIteration + corrIteration;
            hValError = norm(hValPredicted,inf);
% Kojima 2003/02/23 ---> 
%            if (dSigmaRatioCurrent < dSigmaRatioMin) 
%                statusP = -1;
%                if (hValError < hValError0)
%                        xSigmaCurrent = xSigmaPredicted; 
%                else 
%                        xSigmaCurrent = xSigmaPredicted0;
%                        hValError = hValError0;
%                end
% <--- Kojima 2003/02/23
            if statusC >= 1
                xSigmaCurrent = xSigmaPredicted; 
		        statusP=3; 
            else
                if (hValError < hValError0)
                    xSigmaCurrent = xSigmaPredicted; 
                else 
                    xSigmaCurrent = xSigmaPredicted0;
                    hValError = hValError0;
                end
                if hValError < accINfVal
                    statusP = 4;
                else
                    if dSigmaRatioCurrent < dSigmaRatioMin
                        statusP = -1;
                    else
                        statusP = 5; 
                    end
                end
            end
% Kojima 2003/01/16 ---> 
%        end
% <--- Kojima 2003/01/16 
    %%%%% Checking convergence or divergence %%%%% 
%%%%%%%%%% kojima 2003/01/16 ---> 
%    elseif (sigmaValIntoNewton < maxPower * sigmaPredicted)
    elseif ((statusP == 0) | (statusP ==1)) & (sigmaValIntoNewton < maxPower * sigmaCurrent)
%%%%%%%%%% <---
        fSigma = xSigmaCurrent(nDim+1,1);
% Kojima 2003/01/16 --->         
%       if ((statusP == 0) | (statusP == 1)) & ...((statusP == 0) | (statusP == 1)) & ...(divMagOFx < normOFx) 
%            statusP = -2; 
%       elseif (norm(xSigmaCurrent(1:nDim,1)-xSigmaOld(1:nDim,1)) < 100.0 * distMin * norm(xSigmaOld(1:nDim,1))) ...
        if (norm(xSigmaCurrent(1:nDim,1)-xSigmaOld(1:nDim,1)) < 100.0 * distMin * norm(xSigmaOld(1:nDim,1))) ...
            | (dSigmaRatioCurrent < dSigmaRatioMin) 
            xSigmaPredicted0 = zeros(nDim+1,1); 	
%			xSigmaPredicted0(1:nDim,1) = xSigmaCurrent(1:nDim,1) - sigmaCurrent * pDirect1(1:nDim,1);
%			if 1 == 1 % predOrder == 1
    	    xSigmaPredicted0(1:nDim,1) = xSigmaCurrent(1:nDim,1) + (-sigmaCurrent) * pDirect1(1:nDim,1);
%            else % (predOrder == 2) 
%			    secondOrderTerm = 0.5*(-sigmaCurrent)*((-sigmaCurrent) /(xSigmaCurrent(nDim+1,1)-xSigmaOld(nDim+1,1)))...
%				    *(pDirect1(1:nDim,1)-pDirect0(1:nDim,1)); 
%			    xSigmaPredicted0(1:nDim,1) = xSigmaCurrent(1:nDim,1)+(-sigmaCurrent)*pDirect1(1:nDim,1)+secondOrderTerm;
%            end
            finalSW = 1; 
			[hValPredicted0,rowScaling] = ...
				hFunctVect(nDim,noTermsVect,lenPowColVector,powerColVector,coeffColVector,assembleMatrix,...
				xSigmaPredicted0,scalingSW,finalSW);
            hValError0 = norm(hValPredicted0,inf);
            if (hValError0 < 100.0 * hValAccuracy) | (dSigmaRatioCurrent < dSigmaRatioMin) 
                finalSW = 1; 
    			[statusC,corrIteration,xSigmaPredicted,hValPredicted,hValError,rowScaling,colScaling]  ... 
    				= cProced(finalSW,accINfVal,accInNewtonDir,nDim,noTermsVect,powerJMatrix,coeffJMatrix,lenPowColVector,powerColVector,...
    					coeffColVector,assembleMatrix,xSigmaPredicted0,hValPredicted,...
    					NewtonDirMax,distThreshold,ctMax,ctThreshold,corrItMax,scalingSW,rowScaling,colScaling); 
                totalCorrIteration = totalCorrIteration + corrIteration;
                if statusC >= 1
                    xSigmaCurrent = xSigmaPredicted; 
		            statusP = 3; 
                end
            end
        end
    %%%%% Checking too large normOFx
    elseif ( (statusP == 0) | (statusP==1) ) & (1.0e50 < normOFx) % (divMagOFx * 1.0e4 < normOFx) 
        fSigma = xSigmaCurrent(nDim+1,1);
        statusP = -4; 
	end
    %%%%% Predictor-corrector iteration
    %%%%% Only the first order preictor; the socond order has not been
    %%%%% incorpolated. 
	if (statusP == 0) | (statusP==1) 						
			xSigmaPredicted = zeros(nDim+1,1); 	
			xSigmaPredicted(nDim+1,1) = sigmaPredicted; % store the t value predicted. 
			% the predictor step lenght in the t space. 
%			mindSigmaRatio = min([mindSigmaRatio,dSigmaRatioCurrent]); % for statistical information
			% Setting the x value of the predicted point
			if predOrder == 1
    			xSigmaPredicted(1:nDim,1) = xSigmaCurrent(1:nDim,1) + dSigma * pDirect1(1:nDim,1);
            else % (predOrder == 2) 
			    secondOrderTerm = 0.5*dSigma*(dSigma/(xSigmaCurrent(nDim+1,1)-xSigmaOld(nDim+1,1)))...
				    *(pDirect1(1:nDim,1)-pDirect0(1:nDim,1)); 
			        xSigmaPredicted(1:nDim,1) = xSigmaCurrent(1:nDim,1)+dSigma*pDirect1(1:nDim,1)+secondOrderTerm;
            end	
			% Computing the function value 
            finalSW = 0; 
			[hValPredicted,rowScaling] = ...
				hFunctVect(nDim,noTermsVect,lenPowColVector,powerColVector,coeffColVector,assembleMatrix,...
				xSigmaPredicted,scalingSW,finalSW); 
			%%%%% corrector procedure in C^n
            finalSW = 0; 
%            horizontalSW = 0; 
%            if horizontalSW == 0 % horizontalSW == 0 
    	    [statusC,corrIteration,xSigmaPredicted,hValPredicted,hValError,rowScaling,colScaling]  ... 
    				= cProced(finalSW,hValAccuracy,distMin,nDim,noTermsVect,powerJMatrix,coeffJMatrix,lenPowColVector,powerColVector,...
    					coeffColVector,assembleMatrix,xSigmaPredicted,hValPredicted,...
    					NewtonDirMax,distThreshold,ctMax,ctThreshold,corrItMax,scalingSW,rowScaling,colScaling); 
%            else 
%    			[statusC,corrIteration,xSigmaPredicted,hValPredicted,hValError,rowScaling,colScaling]  ... 
%    				= cProced2(finalSW,hValAccuracy,distMin,nDim,noTermsVect,powerJMatrix,coeffJMatrix,lenPowColVector,powerColVector,...
%    					coeffColVector,assembleMatrix,pDirect1,xSigmaPredicted,hValPredicted,...
%    					NewtonDirMax,distThreshold,ctMax,ctThreshold,corrItMax,scalingSW,rowScaling,colScaling); 
%                sigmaPredicted = xSigmaPredicted(nDim+1,1);     
%            end
%            horizontalSW = 0; 
            totalCorrIteration = totalCorrIteration + corrIteration;
			if statusC >= 1 % accept the corrector procedure 
				% computation of the next predictor direction ---> 
				[DhMatrix,colScaling,JacobScaling] = ...
					JacobianMatrix(nDim,noTermsVect,lenPowColVector,coeffColVector,assembleMatrix,powerJMatrix,coeffJMatrix,...
					xSigmaPredicted,scalingSW,rowScaling,finalSW); 
%%%%% New row scling of the Jacobian matrix, 2003/01/26 ---> 
				%%%%% Solving the Newton equation by svd factorization ---> 
                if scalingSW <= 3
    				normRightHand = norm(DhMatrix(:,nDim+1)); 
					% Kojima 2003/02/22 --->
					% To place all real and complex nonzero elements into DhMatrix(:,1:nDim)
					% This is necessary to use svd in MATLAB version 5.2
						DhMatrix(:,1:nDim) = DhMatrix(:,1:nDim) + extSmallNumber * rand(nDim,nDim) * (rand(1,1)+i);
					% <--- Kojima 2003/02/22
    				[UMat,SMat,VMat] = svd(DhMatrix(:,1:nDim)); 
    				%%% small perturbation to ensure the nonsingularity of SMat
    				SVect = max(diag(SMat), min(extSmallNumber,normRightHand) * ones(nDim,1)); 
    				pDirect2 = [-(VMat * ((UMat' * DhMatrix(:,nDim+1)) ./ SVect)); 1.0];
                else % scalingSW == 4
% Kojima 2003/02/22 ---> 
%                    sDh = zeros(nDim,nDim+1); 
%                    for k=1:nDim
%                         sDh(k,:) = DhMatrix(k,:) / JacobScaling(1,k);    
%					 end
					sDh = diag(ones(1,nDim) ./ JacobScaling) * DhMatrix; 
% <--- Kojima 2003/02/22 
				    normRightHand = max([norm(sDh(:,nDim+1)),1.0]); 
					% Kojima 2003/02/22 --->
					% To place all real and complex nonzero elements into DhMatrix(:,1:nDim)
					% This is necessary to use svd in MATLAB version 5.2
						sDh(:,1:nDim) = sDh(:,1:nDim) + extSmallNumber * rand(nDim,nDim) * (rand(1,1)+i);
					% <--- Kojima 2003/02/22
				    [UMat,SMat,VMat] = svd(sDh(:,1:nDim)); 
				    %%% small perturbation to ensure the nonsingularity of SMat
				    SVect = max(diag(SMat), min(extSmallNumber,normRightHand) * ones(nDim,1)); 
				    pDirect2 = [-(VMat * ((UMat' * sDh(:,nDim+1)) ./ SVect)); 1.0];
                end
				%%%%% <--- Solving the Newton equation by svd factorization 
%%%%% <--- New row scaling of the Jacobian matrix, 2003/01/26  
				minSing = (min(abs(diag(SMat)'))); 
                maxSing = (max(abs(diag(SMat)'))); 
                % Kojima 2002/12/31 ---> 
                maxCondNo = max([maxCondNo,maxSing/minSing]); 
                % <--- Kojima 2002/12/31 
				if scalingSW >= 2
					pDirect2(1:nDim,1) = pDirect2(1:nDim) ./ colScaling'; 
				end
				% <--- computation of the next predictor direction
				% computation of the angle -1 <= theta <= 1 between the previous 
				% and the new predictor directions. 
				if angleSW == 1
					[theta] = angleTwo(pDirect1(1:nDim,1),pDirect2(1:nDim,1)); 
				else 
					theta = 0.5 * (angleMin + 1.0);
				end		
				% computation of the condition number of the coefficient matrix of 
				% the Newton system of equations in the last iteration ---> 
%				if informationLevel >= 1
%					[GMat] = realMatrix(nDim,DhMatrix);
%					condGMat = cond(GMat(:,1:nDim*2));
%				end
				% <---
				% Check the angle to see whether we accept the iterate just computed ---> 
				if (theta > angleMin) | (predIteration <=1) % accept the iterate 
					if (theta < angleThDown) 
						statusC = 1; 	% try to keep the predictor step length. 
					end
					% Update the iterates for the next predictor iteration
					xSigmaOld = xSigmaCurrent;	
					xSigmaCurrent = xSigmaPredicted; 
					hValCurrent = hValPredicted;
					sigmaOld = sigmaCurrent; 
                    sigmaCurrent = sigmaPredicted; 
					pDirect0 = pDirect1; 
					pDirect1 = pDirect2; 
					angleSW = 1; 
						% store the current predictor direction for a possible case 
						% when the next predictor procedure fails. 
%					normOFx = norm(xSigmaCurrent(1:nDim,1),inf); 
					normOFx = norm(xSigmaCurrent(1:nDim,1)); 
                    maxNormOFx = max([normOFx,maxNormOFx]); 
					normOFdx = norm(pDirect1(1:nDim,1));
                    normOFpDirect = norm(pDirect1(1:nDim,1)); 
					% end of "if (theta > angleMin) | (predIteration <=1) % accept the iterate" 
				else
					statusC = -4;
				end
			end % end of "if statusC >= 1 % accept the corrector procedure" 
	end % "end of "if statusP == 0"
	if (statusP==0) | (statusP==1) 
		if  predItMax < predIteration 
			statusP = -3;	% If the number predIteration of predictior iteration exceeds 
							% its maximum limit predMax, abandon the predictor iteration. 
            fSigma = xSigmaCurrent(nDim+1,1);
		elseif dSigmaRatioCurrent < dSigmaRatioMin	% If the predictor step length predStep in the sigma space gets smaller,  
								% abandon the predictor procedure. 
			statusP = -1;
            fSigma = xSigmaCurrent(nDim+1,1);
		elseif statusC < 0
			dSigmaRatioCurrent = reductionFactor * dSigmaRatioCurrent; 
	 	elseif statusC >= 2 % Expand the predictor step length predStep. 
			if oldStatusC < 0
				dSigmaRatioCurrent = sqrt(expansionFactor) * dSigmaRatioCurrent; 
			else
				dSigmaRatioCurrent = expansionFactor * dSigmaRatioCurrent; 
			end
% Kojima 2003/02/23 ---> 
% Based on a revison of the note, 2003/02/23
			switchValue = -xSigmaCurrent(nDim+1,1) * maxPower; 
			if 1.0 <= switchValue % 1== 1
				dSigmaRatioCurrent = min([dSigmaRatioMax,dSigmaRatioCurrent]); 
			else % switchValue < 1.0 
				maxValue = min([parameter.dTauMax/switchValue,parameter.dTauMax.^0.3]); 		
				dSigmaRatioCurrent = min([maxValue,dSigmaRatioCurrent]);
			end
% <--- Kojima 2003/02/23
        end
        mindSigmaRatio = min([mindSigmaRatio,dSigmaRatioCurrent]); % for statistical information
	end
	oldStatusC = statusC; 
%%%%% Kojima 2001/12/24 ---> 
	if informationLevel >= 0 
		if ((informationLevel == 1) & ((mod(predIteration,howOften) == 1) | (howOften == 1)))...
			| ((1 <= statusC) & (minSing < minSingForNonsing) & (singularSW == 0))
			if ((1 <= statusC) & (minSing < minSingForNonsing) & (singularSW == 0))
				singularSW = singularSW + 1; 
				if (informationLevel == 0)
					noteFID = fopen(noteFileName,'a');
					fprintf(noteFID,'#!');				
					writeHeadderInformation(noteFID); 
					fprintf(noteFID,'#!');				
					fclose(noteFID); 
				end 
			elseif (2 <= predIteration) & (mod(predIteration,howOften*20) == 1)
%				writeHeadderName(1,kcell,numOfInitPoints,outputHeadName,pthInitPoint); 
%				writeHeadderInformation(1); 
				noteFID = fopen(noteFileName,'a');
				writeHeadderName(noteFID,kcell,numOfInitPoints,outputHeadName,pthInitPoint); 
				writeHeadderInformation(noteFID); 
				fclose(noteFID); 
			end
			noteFID = fopen(noteFileName,'a');
			writeIterationInformation(noteFID,angleSW,statusC,nDim,predIteration,...
				xSigmaCurrent,hValError,normOFx,dSigmaRatioCurrent,corrIteration,minSing,maxSing,theta);
			fclose(noteFID); 
		end
	end
%%%%% <--- Kojima 2001/12/24

%%%%% <--- Kojima 2001/11/11 
end
%%%%% <--- main loop

if (informationLevel == 1) 
	noteFID = fopen(noteFileName,'a');
	writeIterationInformation(noteFID,angleSW,statusC,nDim,predIteration,...
		xSigmaCurrent,hValError,normOFx,dSigma,corrIteration,minSing,maxSing,theta);
	fclose(noteFID); 
end

%%%%% Kojima 2001/11/11 ---> 
% Kojima 2002/12/31 --->
% 
scalingSW = 0; 
% 
% <--- Kojima 2002/12/31 
xSigmaCurrent(nDim+1,1) = 0.0; 
finalSW = 1; 
[hValCurrent,rowScaling] = ...
hFunctVect(nDim,noTermsVect,lenPowColVector,powerColVector,coeffColVector,assembleMatrix,...
	xSigmaCurrent,scalingSW,finalSW); 
hValError = norm(hValCurrent,inf);
% normOFx = norm(xSigmaCurrent(1:nDim,1),inf);
normOFx = norm(xSigmaCurrent(1:nDim,1));
maxNormOFx = max([normOFx,maxNormOFx]); 
[DhMatrix,colScaling,JacobScaling] = ...
	JacobianMatrix(nDim,noTermsVect,lenPowColVector,coeffColVector,assembleMatrix,... 
	powerJMatrix,coeffJMatrix,xSigmaCurrent,scalingSW,rowScaling,finalSW); 
% Kojima 2003/02/22 --->
% To place all real and complex nonzero elements into DhMatrix(:,1:nDim)
% This is necessary to use svd in MATLAB version 5.2
DhMatrix(:,1:nDim) = DhMatrix(:,1:nDim) + extSmallNumber * rand(nDim,nDim) * (rand(1,1)+i);
% <--- Kojima 2003/02/22
[UMat,SMat,VMat] = svd(DhMatrix(:,1:nDim)); 
minSing = (min(abs(diag(SMat)'))); 
maxSing = (max(abs(diag(SMat)'))); 
hValErr2 = norm(hValCurrent); 
SVect = max(diag(SMat), min(extSmallNumber,hValErr2) * ones(nDim,1)); 
dx = [-VMat * ((UMat'*hValCurrent) ./ SVect); 0.0];
normOFdx = norm(dx); 

endingTime = cputime;
CPUsecond = endingTime - startingTime; 

if (informationLevel == 1) | ((informationLevel >= 0) & (singularSW >= 1))
	noteFID = fopen(noteFileName,'a');
	fprintf(noteFID,'#  cell  init statusP   pIT    TcIT     cpu hValError     normOFx       minSing    condNo  normOFdx  minPstep    maxPower\n'); 
	if maxSing < 1.0e99 * minSing
		fprintf(noteFID,'%7d  %4d  %+2d    %6d %7d %7.1f  %6.2e  %8.4e  %+8.4e %8.4e  %6.2e  %6.2e  %8.4e\n',...
		kcell,pthInitPoint,statusP,predIteration,totalCorrIteration,CPUsecond,hValError,...
		normOFx,minSing,maxSing/minSing,normOFdx,mindSigmaRatio,maxPower); 
	else
		fprintf(noteFID,'%7d  %4d  %+2d    %6d %7d %7.1f  %6.2e  %8.4e  %+8.4e %8.4e  %6.2e  %6.2e  %8.4e\n',...
		kcell,pthInitPoint,statusP,predIteration,totalCorrIteration,CPUsecond,hValError,...
		normOFx,minSing,1.0e99,normOFdx,mindSigmaRatio,maxPower); 
	end
	fclose(noteFID); 
end

return
%%%%% End of function oneCurve
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Writing information ---> 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function writeHeadderName(outputFID,kcell,numOfInitPoints,outputHeadName,pthInitPoint); 
fprintf(outputFID,'# %s %d/%d\n',outputHeadName,pthInitPoint,numOfInitPoints);
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function writeHeadderInformation(outputFID); 
fprintf(outputFID,'#        statusC      sigma      hErr  normOFx dSigmaRatio  cIT    minSing     condNo     angle\n');
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function writeIterationInformation(outputFID,angleSW,statusC,nDim,predIteration,...
	xSigmaPredicted,hValError,normOFx,dSigmaRatio,corrIteration,minSing,maxSing,theta);
if (angleSW == 1) & ((statusC >= 0) | (statusC == -4))
	if maxSing < 1.0e99 * minSing
		fprintf(outputFID,'# %6d:     %+2d %+7.3e  %6.2e %6.2e    %6.2e   %2d  %+6.2e  %+6.2e %+6.2e\n',...
		predIteration,statusC,xSigmaPredicted(nDim+1,1),hValError,normOFx,dSigmaRatio,corrIteration,...
        minSing,maxSing/minSing,theta);
	else
		fprintf(outputFID,'# %6d:     %+2d %+7.3e  %6.2e %6.2e    %6.2e   %2d  %+6.2e  %+6.2e %+6.2e\n',...
		predIteration,statusC,xSigmaPredicted(nDim+1,1),hValError,normOFx,dSigmaRatio,corrIteration,...
        minSing,1.0e99,theta);
	end
else
	fprintf(outputFID,'# %6d:     %+2d %+7.3e  %6.2e %6.2e    %6.2e   %2d     \n',...
		predIteration,statusC,xSigmaPredicted(nDim+1,1),hValError,normOFx,dSigmaRatio,corrIteration);
end
return
%%%%% <--- Writing information 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Kojima 2003/01/09 
%%%%% This procedure should be excuted once before starting 
%%%%% predictor-corrector procedures. 
%%%%%
function [lenPowColVector,powerColVector,coeffColVector,assembleMatrix] = ...
	prepFunctEval(nDim,noTermsVect,coeffMatrix,powerMatrix);

lenPowColVector = 0;
for jthRow = 1:nDim
	lenPowColVector = lenPowColVector + noTermsVect(jthRow); 
end	
powerColVector = sparse(zeros(lenPowColVector,nDim+1));
coeffColVector = sparse(zeros(lenPowColVector,1));
assembleMatrix = sparse(zeros(nDim,lenPowColVector));
k=0; 
for jthRow = 1:nDim
	for kthTerm=1:noTermsVect(jthRow) 
		k=k+1;
		powerColVector(k,:) = powerMatrix{jthRow}(kthTerm,:); 
		coeffColVector(k) = coeffMatrix{jthRow}(kthTerm); 
		assembleMatrix(jthRow,k) = 1;
	end
end
debug = 0;
if debug == 1
	lenPowColVector
	disp(full(powerColVector));
	disp(full(coeffColVector));
	display(full(assembleMatrix));
end
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [hValVect,rowScaling] = ...
hFunctVect(nDim,noTermsVect,lenPowColVector,powerColVector,coeffColVector,assembleMatrix,xSigmaVect,scalingSW,finalSW); 
%
%	nDim --- 	The dimension of the polynomial system.
%	xSigmaVect 
%		--- The current point, an (nDim+1) \times 1 vector, at which the homotopy 
%			function value is evaluated.
%
%	Note that the last coordinate xSigmaVect(nDim+1,1) \in (-\infty,0] corresponds to the variable log(t), 
%   t \in [0,1]. 
%
%	hValVect
%		--- The homotopy function value, an nDim \times 1 vector

extSmallNumber = exp(-100); 
hValVect = zeros(nDim,1);
rowScaling = ones(nDim,1); 
logABSx = log((max([abs(xSigmaVect(1:nDim,1)'); extSmallNumber*ones(1,nDim)]))'); 
ANGLEx = angle(xSigmaVect(1:nDim,1)); 
logMagOfTerms = powerColVector(:,1:nDim) * logABSx; 
AngleOfTerms  = powerColVector(:,1:nDim) * ANGLEx;
% Kojima 2003/01/04; for revision ---> 
% Orignial ---> 
% terms = coeffColVector .* exp(logMagOfTerms) .* exp(i*AngleOfTerms) .* power(tauRef,powerColVector(:,nDim+1)/powerRef);
% Modified ---> 
% sigma = log(xtVect(nDim+1,1)); 
if finalSW == 1
    terms = coeffColVector .* exp(logMagOfTerms) .* exp(i*AngleOfTerms); 
else
    terms = coeffColVector .* exp(logMagOfTerms) .* exp(i*AngleOfTerms) .* exp( powerColVector(:,nDim+1) * xSigmaVect(nDim+1,1) ); 
end
% <--- Kojima 2003/01/04
hValVect = full(assembleMatrix * terms);
rowScaling = ones(nDim,1); 
if scalingSW >= 1
	ABSterms = abs(terms);
	s = 0; 
% Kojima 2003/02/22 ---> 
	for jthRow = 1:nDim
		rowScaling(jthRow,1) = max([ABSterms(s+1:s+noTermsVect(jthRow));1]);
	%		a = max(ABSterms(s+1:s+noTermsVect(jthRow)));
		s = s+noTermsVect(jthRow);
	%		if a > rowScaling(jthRow,1)
	%			rowScaling(jthRow,1) = a;
	%		end
	end
	% To eliminate ``for loop'', we use here a rwoScaling different from the paper 
	%	rowScaling = assembleMatrix * ABSterms; 
% <--- Kojima 2003/02/22 
	hValVect = hValVect ./ rowScaling;
end
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Kojima 2003/01/09 
%%%%% This procedure should be excuted once before starting 
%%%%% predictor-corrector procedures. 
%%%%%
function [powerJMatrix,coeffJMatrix] = ...
	prepJMatrixEval(nDim,noTermsVect,lenPowColVector,powerColVector);
for diffIndex=1:nDim+1
	powerJMatrix{diffIndex} = powerColVector;
	coeffJMatrix{diffIndex} = sparse(zeros(lenPowColVector,1)); 
end
% Differentiating x_diffIndex
for diffIndex=1:nDim
	for k=1:lenPowColVector
		if powerColVector(k,diffIndex) > 0.5	
			coeffJMatrix{diffIndex}(k,1) = powerJMatrix{diffIndex}(k,diffIndex); 
			powerJMatrix{diffIndex}(k,diffIndex) = powerJMatrix{diffIndex}(k,diffIndex) - 1;
		end
	end
end
% Differentiating sigma
diffIndex = nDim+1; 
for k=1:lenPowColVector
	if powerColVector(k,diffIndex) > 0.5	
		coeffJMatrix{diffIndex}(k,1) = powerJMatrix{diffIndex}(k,diffIndex); 
% Kojima 2003/01/04 ---> 
% Original ---> 
%		powerJMatrix{diffIndex}(k,diffIndex) = powerJMatrix{diffIndex}(k,diffIndex) - 1;
% Modified ---> 
		powerJMatrix{diffIndex}(k,diffIndex) = powerJMatrix{diffIndex}(k,diffIndex);
% <--- Kojima 2003/01/04
	end
end
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Computation of the nDim \times (nDim+1) complex Jacobian matrix of the homotopy function h(x,sigma)
%%%%% Note that sigma = log(t) \in (-\infty,0] for t \in [0,1].
function [DhMatrix,colScaling,JacobScaling] = ...
JacobianMatrix(nDim,noTermsVect,lenPowColVector,coeffColVector,assembleMatrix,powerJMatrix,coeffJMatrix,...
xSigmaVect,scalingSW,rowScaling,finalSW); 
%
%	nDim --- 	The dimension of the polynomial system.
%	noTermsVect 
%		--- 1 \time nDim.
%			noTermsVect(1,jthrow) denotes the number of terms 
%			involved in the jth homotopy equation.
%	xSigmaVect 
%		--- The current point, an (nDim+1) \times 1 vector, at which the homotopy 
%			function value is evaluated.
%			Note that the last coordinate xSigmaVect(nDim+1,1) \in (\infty,0] corresponds to log(t). 
%	DhMatrix
%		--- The nDim \times (ndim+1) Jacobian matrix of the homotopy function h(x,sigma) : C^n \times [0,1] ---> C^n. 

extSmallNumber = exp(-100); 
DhMatrix = zeros(nDim,nDim+1);
colScaling = ones(1,nDim); 
logABSx = log((max([abs(xSigmaVect(1:nDim,1)'); extSmallNumber*ones(1,nDim)]))'); 
ANGLEx = angle(xSigmaVect(1:nDim,1)); 

for diffIndex=1:nDim+1
	logMagOfTerms = powerJMatrix{diffIndex}(:,1:nDim) * logABSx; 
	AngleOfTerms  = powerJMatrix{diffIndex}(:,1:nDim) * ANGLEx;
% Kojima 2004/01/04 ---> 
% Original ---> 
%	terms = coeffJMatrix{diffIndex} .* coeffColVector .* exp(logMagOfTerms) .* exp(i*AngleOfTerms) ...
%			.* power(tauRef,powerJMatrix{diffIndex}(:,nDim+1)/powerRef);
% Modified ---> 
if finalSW == 1
	terms = coeffJMatrix{diffIndex} .* coeffColVector .* exp(logMagOfTerms) .* exp(i*AngleOfTerms);
else
	terms = coeffJMatrix{diffIndex} .* coeffColVector .* exp(logMagOfTerms) .* exp(i*AngleOfTerms) ...
			.* exp(powerJMatrix{diffIndex}(:,nDim+1)*xSigmaVect(nDim+1,1));
end
% <--- Kojima 2003/01/04
	DhMatrix(:,diffIndex) = full(assembleMatrix * terms);
end

%%%%% Kojima 2001/12/17
normOfDhMatrix = norm(DhMatrix(:,1:nDim),1);
if normOfDhMatrix > 1.0e+200
	fprintf('\n\n normOfDhMatrix > %+8.3e\n\n',normOfDhMatrix);
end
%%%%% Kojima 2001/12/17

JacobScaling = ones(1,nDim); 
colScaling = ones(1,nDim); 
if scalingSW >= 1
% Kojima 2003/02/22 ---> 
%	for jthRow=1:nDim
%		DhMatrix(jthRow,:) = DhMatrix(jthRow,:) / rowScaling(jthRow,1);
%	end
	DhMatrix = diag(ones(nDim,1) ./ rowScaling) * DhMatrix; 
	if (scalingSW >= 2) 
%	for diffIndex = 1:nDim
	% Kojima 2002/12/31 ---> 
	% Old column scaling 
%            if (scalingSW == 2) 
%			    colScaling(1,diffIndex) = max([colScaling(1,diffIndex), abs(DhMatrix(:,diffIndex)')]); 
%            else % (scalingSW >= 3) 
	% New column scaling based on the linear scaling of each complex variable 
%				colScaling(1,diffIndex) = 1.0 / max([1.0, abs(xSigmaVect(diffIndex,1))]);
%			end
	% <--- Kojima 2002/12/31 
%			DhMatrix(:,diffIndex) = DhMatrix(:,diffIndex) /  colScaling(1,diffIndex); 
%		end
		if (scalingSW == 2) 
			colScaling = max([colScaling; abs(DhMatrix(:,1:nDim))]); 
        else % (scalingSW >= 3) 
			colScaling = ones(1,nDim) ./ max([ones(1,nDim); abs(xSigmaVect(1:nDim,1))']);
		end
		DhMatrix(:,1:nDim) = DhMatrix(:,1:nDim) * diag(ones(1,nDim) ./ colScaling); 
% <--- Kojima 2003/02/22  		
	end
	% Kojima 2003/02/17 ---> 
	if scalingSW == 4
%		for k=1:nDim
%			JacobScaling(1,k) = max([norm(DhMatrix(k,1:nDim)),1.0e-7]); 
%		end
		JacobScaling = max([sqrt(diag(DhMatrix(:,1:nDim) * DhMatrix(:,1:nDim)'))'; ones(1,nDim)*1.0e-7]); 
%		JacobScaling =  max([(abs(DhMatrix(:,1:nDim)) * ones(nDim,1))'; ones(1,nDim)*1.0e-7]);
	end
end
% <--- Kojima 2003/02/17

% Kojima 2003/03/02, to ensure all elements to be complex numbers --->
DhMatrix(:,1:nDim) = DhMatrix(:,1:nDim) + extSmallNumber * (rand(nDim,nDim) + i * rand(nDim,nDim)); 
% <--- Kojima 2003/03/02 


return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%	Corrector procedure with a fixed t in the space C^n
function [statusC, corrIteration, xSigmaCurrent, hValCurrent, hValError,rowScaling,colScaling] ... 
= cProced(finalSW,hValAccuracy,distMin,nDim,noTermsVect,powerJMatrix,coeffJMatrix,lenPowColVector,...
powerColVector,coeffColVector,assembleMatrix,xSigmaCurrent,hValCurrent,NewtonDirMax,...
distThreshold,ctMax,ctThreshold,corrItMax,scalingSW,rowScaling,colScaling); 

%%% Kojima 2001/11/11 ---> 
extSmallNumber = 1.0e-50; 
%%%%% <--- Kojima 2001/11/11 
%%%%% Kojima 2003/01/30 ---> 
% normOFx = max([norm(xSigmaCurrent(1:nDim,1),inf),1]); 
normOFx = max([norm(xSigmaCurrent(1:nDim,1)),1]); 
%%%%% <--- Kojima 2003/01/30
NewtonDirMax = NewtonDirMax * normOFx; 
distMin = min([distMin * normOFx, 0.001]);
distThreshold = distThreshold * normOFx; 

statusC = 0; 
% = 2	--- success and try to expand the current predictor predStep
% = 1	--- success and try to keep the current predictor predStep
% = 0	---	continue
% =-1	---	fail and retry the predictor procedure with the half predictor 
%			step length. 

corrIteration = 0;
contr = 0.0;
contr2 = 0.0;

hValError = norm(hValCurrent,inf);

if (finalSW == 0) & (hValError < hValAccuracy) 
	statusC = 2;
%	fprintf('no corrector iteration since hValError < hValAccuracy\n'); 
else 
	[DhMatrix,colScaling,JacobScaling] = ...
		JacobianMatrix(nDim,noTermsVect,lenPowColVector,coeffColVector,assembleMatrix,powerJMatrix,coeffJMatrix,...
		xSigmaCurrent,scalingSW,rowScaling,finalSW); 
%%%%% New row scling of the Jacobian matrix, 2003/01/26 ---> 
	%%%%% Solving the Newton equation by svd factorization ---> 
%    trial = 1; 
    if scalingSW <= 3
    	hValErr2 = norm(hValCurrent); 
		% Kojima 2003/02/22 --->
		% To place all real and complex nonzero elements into DhMatrix(:,1:nDim)
		% This is necessary to use svd in MATLAB version 5.2
			DhMatrix(:,1:nDim) = DhMatrix(:,1:nDim) + extSmallNumber * rand(nDim,nDim) * (rand(1,1)+i);
		% <--- Kojima 2003/02/22
    	[UMat,SMat,VMat] = svd(DhMatrix(:,1:nDim)); 
        %%% small perturbation to ensure the nonsingularity of SMat
    	SVect = max(diag(SMat), min(extSmallNumber,hValErr2) * ones(nDim,1)); 
    	corrDirection = [-(VMat * ((UMat'*hValCurrent) ./ SVect)); 0.0];
    else % scalingSW == 4 
% Kojima 2003/02/22 ---> 
%        sh = zeros(nDim,1); 
%        sDh = zeros(nDim,nDim); 
%        for k=1:nDim
%            normOFrow = max([norm(DhMatrix(k,1:nDim)),1.0]);
%            sh(k,1) = hValCurrent(k,1) / normOFrow;
%            sDh(k,:) = DhMatrix(k,1:nDim) / normOFrow;
%            sh(k,1) = hValCurrent(k,1) / JacobScaling(1,k);
%            sDh(k,:) = DhMatrix(k,1:nDim) / JacobScaling(1,k);
%        end
		sh = hValCurrent ./ JacobScaling'; 
		sDh = diag(ones(1,nDim) ./ JacobScaling) * DhMatrix(:,1:nDim); 
        shErr2 = norm(sh); 
% <--- Kojima 2003/02/22
		% Kojima 2003/02/22 --->
		% To place all real and complex nonzero elements into DhMatrix(:,1:nDim)
		% This is necessary to use svd in MATLAB version 5.2
				sDh = sDh + extSmallNumber * rand(nDim,nDim) * (rand(1,1)+i);
		% <--- Kojima 2003/02/22
    	[UMat,SMat,VMat] = svd(sDh); 
        %%% small perturbation to ensure the nonsingularity of SMat
    	SVect = max(diag(SMat), min(extSmallNumber,shErr2) * ones(nDim,1)); 
    	corrDirection = [-(VMat * ((UMat'*sh) ./ SVect)); 0.0];
    end
%    trial = 0; 
    %%%%% <--- Solving the Newton equation by svd factorization 
%%%%% <--- New row scling of the Jacobian matrix, 2003/01/26
% Kojima 2003/02/17 ---> 
%	dy = corrDirection(1:nDim,1); 
	if scalingSW >= 2
		corrDirection(1:nDim,1) = corrDirection(1:nDim,1) ./ colScaling'; 
	end
%	if 0 == 1 % finalSW == 0 
%		dist = norm(dy);
%	else
		dist = norm(corrDirection); 
%	end; 
% <--- Kojima 2003/02/17 
	if (finalSW == 0) & (dist < distMin)
		statusC = 2;
	end
end

% Kojima 2003/02/26 ---> 
if (finalSW == 1) 
    xSigmaBest = xSigmaCurrent; 
    hValueBest = hValCurrent; 
    hErrorBest = hValError;
    distBest = dist; 
end
% <--- Kojima 2003/02/26

moreAccurate = 0; 

while (statusC == 0) 
	corrIteration = corrIteration + 1; 
	if corrIteration == 1
		dist1 = dist; distOld = dist; 
		if dist1 > NewtonDirMax 
			statusC = -1;
		end
	else
		contr = dist/distOld; 
		if corrIteration == 2
			contr2 = contr; 
		end
		if (NewtonDirMax < dist)
			statusC = -1;
		elseif (ctMax < contr)
			statusC = -2; 
		end
		distOld = dist;
	end
	if statusC == 0 
		xSigmaCurrent = xSigmaCurrent + corrDirection;
		[hValCurrent,rowScaling] = ...
			hFunctVect(nDim,noTermsVect,lenPowColVector,powerColVector,coeffColVector,assembleMatrix,...
			xSigmaCurrent,scalingSW,finalSW); 
		hValError = norm(hValCurrent,inf); 
		[DhMatrix,colScaling,JacobScaling] = ...
			JacobianMatrix(nDim,noTermsVect,lenPowColVector,coeffColVector,assembleMatrix,powerJMatrix,coeffJMatrix,...
			xSigmaCurrent,scalingSW,rowScaling,finalSW); 
%%%%% New row scling of the Jacobian matrix, 2003/01/26 ---> 
	%%%%% Solving the Newton equation by svd factorization ---> 
%   trial = 1; 
	    if scalingSW <= 3 
	    	hValErr2 = norm(hValCurrent); 
			% Kojima 2003/02/22 --->
			% To place all real and complex nonzero elements into DhMatrix(:,1:nDim)
			% This is necessary to use svd in MATLAB version 5.2
			DhMatrix(:,1:nDim) = DhMatrix(:,1:nDim) + extSmallNumber * rand(nDim,nDim) * (rand(1,1)+i);
			% <--- Kojima 2003/02/22
	    	[UMat,SMat,VMat] = svd(DhMatrix(:,1:nDim)); 
	        %%% small perturbation to ensure the nonsingularity of SMat
	    	SVect = max(diag(SMat), min(extSmallNumber,hValErr2) * ones(nDim,1)); 
	    	corrDirection = [-(VMat * ((UMat'*hValCurrent) ./ SVect)); 0.0];
	    else % scalingSW == 4 
			% Kojima 2003/02/22 ---> 
			%        sh = zeros(nDim,1); 
			%        sDh = zeros(nDim,nDim); 
			%        for k=1:nDim
			%            normOFrow = max([norm(DhMatrix(k,1:nDim)),1.0]);
			%            sh(k,1) = hValCurrent(k,1) / normOFrow;
			%            sDh(k,:) = DhMatrix(k,1:nDim) / normOFrow;
			%            sh(k,1) = hValCurrent(k,1) / JacobScaling(1,k);
			%            sDh(k,:) = DhMatrix(k,1:nDim) / JacobScaling(1,k);
			%        end
			sh = hValCurrent ./ JacobScaling'; 
			sDh = diag(ones(1,nDim) ./ JacobScaling) * DhMatrix(:,1:nDim); 
    	    shErr2 = norm(sh); 
			% <--- Kojima 2003/02/22
			% Kojima 2003/02/22 --->
			% To place all real and complex nonzero elements into DhMatrix(:,1:nDim)
			% This is necessary to use svd in MATLAB version 5.2
			sDh = sDh + extSmallNumber * rand(nDim,nDim) * (rand(1,1)+i);
			% <--- Kojima 2003/02/22
	    	[UMat,SMat,VMat] = svd(sDh); 
	        %%% small perturbation to ensure the nonsingularity of SMat
	    	SVect = max(diag(SMat), min(extSmallNumber,shErr2) * ones(nDim,1)); 
	    	corrDirection = [-(VMat * ((UMat'*sh) ./ SVect)); 0.0];
	    end
		%    trial = 0; 
	    %%%%% <--- Solving the Newton equation by svd factorization 
		%%%%% <--- New row scling of the Jacobian matrix, 2003/01/26
		% Kojima 2003/02/17 ---> 
		%		dy = corrDirection(1:nDim,1); 
		if scalingSW >= 2
			corrDirection(1:nDim,1) = corrDirection(1:nDim,1) ./ colScaling'; 
		end
		%		if 0 == 1 % finalSW == 0 
		%			dist = norm(dy);
		%		else
		dist = norm(corrDirection); 
% Kojima 2003/02/26 ---> 
%       if (finalSW == 1) & (max([hValError,dist]) < max([hErrorBest,distBest]));  
        if (finalSW == 1) & (hValError < hErrorBest);  
            xSigmaBest = xSigmaCurrent; 
            hValueBest = hValCurrent; 
            hErrorBest = hValError; 
            distBest = dist; 
        end
% <--- Kojima 2003/02/26
		%		end; 
		% <--- Kojima 2003/02/17 
		if (finalSW == 0) & ((dist < distMin) | (hValError < hValAccuracy)) 
			if (dist1 < distThreshold) & (contr2 < ctThreshold)
				statusC = 2;
			else
				statusC = 1;
			end
		elseif (finalSW == 1) & (dist < distMin) & (hValError < hValAccuracy)
			moreAccurate = moreAccurate + 1; 
			if moreAccurate > 1.5
				statusC = 2;
			end
		elseif corrIteration >= corrItMax 
			statusC = -3;
% Kojima 2003/02/26 ---> 
            if finalSW == 1
                xSigmaCurrent = xSigmaBest; 
                hValCurrent = hValueBest; 
                hValError = hErrorBest;  
% <--- Kojima 2003/02/26
            end
		end
	end
end
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%	Corrector procedure with a fixed t in the space C^n
%%% Not used in CMPSm26.m, January 30, 2003
function [statusC, corrIteration, xSigmaCurrent, hValCurrent, hValError,rowScaling,colScaling] ... 
= cProced2(finalSW,hValAccuracy,distMin,nDim,noTermsVect,powerJMatrix,coeffJMatrix,lenPowColVector,...
    powerColVector,coeffColVector,assembleMatrix,pDirect,xSigmaCurrent,hValCurrent,NewtonDirMax,...
    distThreshold,ctMax,ctThreshold,corrItMax,scalingSW,rowScaling,colScaling); 

% !!!!! scalingSW = 0 !!!!!

extSmallNumber = 1.0e-50; 
% normOFx = max([norm(xSigmaCurrent(1:nDim,1),inf),1]); 
normOFx = max([norm(xSigmaCurrent(1:nDim,1)),1]); 
NewtonDirMax = NewtonDirMax * normOFx; 
distMin = min([distMin * normOFx, 0.001]);
distThreshold = distThreshold * normOFx; 

statusC = 0; 
% = 2	--- success and try to expand the current predictor predStep
% = 1	--- success and try to keep the current predictor predStep
% = 0	---	continue
% =-1	---	fail and retry the predictor procedure with the half predictor 
%			step length. 

corrIteration = 0;
contr = 0.0;
contr2 = 0.0;

hValError = norm(hValCurrent,inf);
if (finalSW == 0) & (hValError < hValAccuracy) 
	statusC = 2;
%	fprintf('no corrector iteration since hValError < hValAccuracy\n'); 
else 
    scaleFactor3 = max( [norm(pDirect(1:nDim,1)),1] ); 
    pDirect = pDirect / scaleFactor3; 
    [DhMatrix,colScaling,JacobScaling] = ...
		JacobianMatrix(nDim,noTermsVect,lenPowColVector,coeffColVector,assembleMatrix,powerJMatrix,coeffJMatrix,...
		xSigmaCurrent,scalingSW,rowScaling,finalSW); 
   [GMat] = realMatrix(nDim,DhMatrix);
   sDirect = zeros(nDim+1,1); 
   if scalingSW >= 2
       DhMatrix(:,nDim+1) = DhMatrix(:,nDim+1) * abs(xSigmaCurrent(nDim+1,1)); 
       sDirect(1:nDim,1) = pDirect(1:nDim,1) ./ colScaling'; 
       sDirect(nDim+1,1) = pDirect(nDim+1,1) * abs(xSigmaCurrent(nDim+1,1)); 
   else
       sDirect = pDirect;
   end
   [qVect] = [realVector(nDim,sDirect(1:nDim,1));sDirect(nDim+1,1)];
    AMat = [GMat; qVect']; 
    rVect = [-realVector(nDim,hValCurrent); 0.0];
%%%%% Solving the Newton equation by svd factorization ---> 
	[UMat,SMat,VMat] = svd(AMat); 
%%% small perturbation to ensure the nonsingularity of SMat
    normRightHand = norm(rVect); 
    SVect = max(diag(SMat), min(extSmallNumber,normRightHand) * ones(2*nDim+1,1)); 
	dw = VMat * ((UMat'*rVect) ./ SVect);
    corrDirection = zeros(nDim+1,1); 
    corrDirection(1:nDim,1) = complexVector(nDim,dw(1:2*nDim,1));
    corrDirection(nDim+1,1) = dw(2*nDim+1,1); 
%%%%% <--- Solving the Newton equation by svd factorization 
	if scalingSW >= 2
		corrDirection(1:nDim,1) = corrDirection(1:nDim,1) ./ colScaling'; 
        corrDirection(nDim+1,1) = corrDirection(nDim+1,1) * abs(xSigmaCurrent(nDim+1,1));
	end
	dist = norm(corrDirection); 
	if (finalSW == 0) & (dist < distMin)
		statusC = 2;
	end
end

while (statusC == 0) 
	corrIteration = corrIteration + 1; 
	if corrIteration == 1
		dist1 = dist; distOld = dist; 
		if dist1 > NewtonDirMax 
			statusC = -1;
		end
	else
		contr = dist/distOld; 
		if corrIteration == 2
			contr2 = contr; 
		end
		if (NewtonDirMax < dist)
			statusC = -1;
		elseif (ctMax < contr)
			statusC = -2; 
		end
		distOld = dist;
	end
	if statusC == 0 
%        size(xSigmaCurrent)
%        size(corrDirection)
		xSigmaCurrent = xSigmaCurrent + corrDirection;
		[hValCurrent,rowScaling] = ...
			hFunctVect(nDim,noTermsVect,lenPowColVector,powerColVector,coeffColVector,assembleMatrix,...
			xSigmaCurrent,scalingSW,finalSW); 
		hValError = norm(hValCurrent,inf);
		[DhMatrix,colScaling,JacobScaling] = ...
			JacobianMatrix(nDim,noTermsVect,lenPowColVector,coeffColVector,assembleMatrix,powerJMatrix,coeffJMatrix,...
			xSigmaCurrent,scalingSW,rowScaling,finalSW); 
        sDirect = zeros(nDim+1,1); 
        if scalingSW >= 2
            DhMatrix(:,nDim+1) = DhMatrix(:,nDim+1) * abs(xSigmaCurrent(nDim+1,1)); 
            sDirect(1:nDim,1) = pDirect(1:nDim,1) ./ colScaling'; 
            sDirect(nDim+1,1) = pDirect(nDim+1,1) * abs(xSigmaCurrent(nDim+1,1)); 
        else
            sDirect = pDirect;
        end
        [qVect] = [realVector(nDim,sDirect(1:nDim,1));sDirect(nDim+1,1)];
        [GMat] = realMatrix(nDim,DhMatrix);
        AMat = [GMat; qVect']; 
        rVect = [-realVector(nDim,hValCurrent); 0.0];
        %%%%% Solving the Newton equation by svd factorization ---> 
	    [UMat,SMat,VMat] = svd(AMat); 
        %%% small perturbation to ensure the nonsingularity of SMat
        normRightHand = norm(rVect); 
        SVect = max(diag(SMat), min(extSmallNumber,normRightHand) * ones(2*nDim+1,1)); 
    	dw = VMat * ((UMat'*rVect) ./ SVect);
        corrDirection = zeros(nDim+1,1); 
        corrDirection(1:nDim,1) = complexVector(nDim,dw(1:2*nDim,1));
        corrDirection(nDim+1,1) = dw(2*nDim+1,1); 
        %%%%% <--- Solving the Newton equation by svd factorization 
		if scalingSW >= 2
			corrDirection(1:nDim,1) = corrDirection(1:nDim,1) ./ colScaling'; 
            corrDirection(nDim+1,1) = corrDirection(nDim+1,1) * abs(xSigmaCurrent(nDim+1,1));
		end
		dist = norm(corrDirection); 
		if ((finalSW == 0) & ((dist < distMin) | (hValError < hValAccuracy))) ... 
           | ((finalSW == 1) & (dist < distMin) & (hValError < hValAccuracy))
			if (dist1 < distThreshold) & (contr2 < ctThreshold)
				statusC = 2;
			else
				statusC = 1;
			end
		elseif corrIteration >= corrItMax 
			statusC = -3;
		end
	end
end
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Computation of the angle of two complex vectors 
function [theta] = angleTwo(aVect,bVect);
re_aVect = real(aVect);
re_bVect = real(bVect);
imag_aVect = imag(aVect);
imag_bVect = imag(bVect);
numerator = re_aVect' * re_bVect + imag_aVect' * imag_bVect;
denominator = 	(re_aVect' * re_aVect + imag_aVect' * imag_aVect) ...
			*	(re_bVect' * re_bVect + imag_bVect' * imag_bVect);
if denominator > 1.0e-20
%if denominator > 1.0e-5
	denominator = sqrt(denominator);
	theta = numerator / denominator;
else
	theta = 1.0;
end
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% The conversion of a complex nDim \times (nDim+1) matrix DMat
%%%%% into the corresponding (2*nDim) \times (2*nDim+1) matrix GMat
function [GMat] = realMatrix(nDim,DMat);
GMat = zeros(2*nDim,2*nDim+1);
for j=1:nDim
	for k=1:nDim
		a = real(DMat(j,k));
		b = imag(DMat(j,k));
		GMat((j-1)*2+1,(k-1)*2+1) = a;
		GMat((j-1)*2+1,(k-1)*2+2) = -b;
		GMat((j-1)*2+2,(k-1)*2+1) = b;
		GMat((j-1)*2+2,(k-1)*2+2) = a; 
	end
	GMat((j-1)*2+1,2*nDim+1) = real(DMat(j,nDim+1));
	GMat((j-1)*2+2,2*nDim+1) = imag(DMat(j,nDim+1));
end
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% The conversion of an nDim dimensional complex vector xVect
%%% into the corresponding 2*nDim dimensional real vector wVect.
function [wVect] = realVector(nDim,xVect);
wVect = zeros(2*nDim,1); 
for j=1:nDim
	wVect((j-1)*2+1,1) = real(xVect(j,1));
	wVect((j-1)*2+2,1) = imag(xVect(j,1));
end
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% The conversion of an 2*nDim dimensional real vector wVect
%%% into the corresponding nDim dimensional complex vector. 
function [xVect] = complexVector(nDim,wVect);
xVect = zeros(nDim,1);
for j=1:nDim
	xVect(j,1) = wVect((j-1)*2+1,1) + wVect((j-1)*2+2,1) * i;
end
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [maxPower,totalNoTerms,tPowerVector] = pre4Processing(nDim,noTermsVect,powerMatrix); 
totalNoTerms = 0;
for jthRow=1:nDim
	totalNoTerms=totalNoTerms+noTermsVect(jthRow);
end
tempVect=zeros(1,totalNoTerms);
k=0; 
maxPower = 1; 

for jthRow=1:nDim
	for kthTerm=1:noTermsVect(jthRow)
		if powerMatrix{jthRow}(kthTerm,nDim+1) > 1
			k = k+1;
			tempVect(k) = powerMatrix{jthRow}(kthTerm,nDim+1);
		end
	end
end
tempVect = [1, tempVect(1:k)]; 
totalNoTerms = 1+k; 
tPowerVector = sort(tempVect);
maxPower = tPowerVector(totalNoTerms);
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Kojima 2003/01/09 
%%%%% This procedure should be excuted once before starting 
%%%%% predictor-corrector procedures. 
%%%%%
%%%%%   tPowerAndTheirLog(1,j) = the power of t in some term
%%%%%   tPowerAndTheirLog(2,j) = log(the power of t in some term)
%%%%%
function [maxPower,totalNoTerms,tPowerAndTheirLog] = ...
    preProcessTpower(nDim,noTermsVect,powerMatrix); 
totalNoTerms = 0;
for jthRow=1:nDim
	totalNoTerms=totalNoTerms+noTermsVect(jthRow);
end
tempVect=zeros(1,totalNoTerms);
k=0; 
for jthRow=1:nDim
	for kthTerm=1:noTermsVect(jthRow)
		if powerMatrix{jthRow}(kthTerm,nDim+1) > 1
			k = k+1;
			tempVect(k) = powerMatrix{jthRow}(kthTerm,nDim+1);
		end
	end
end
tempVect = [1, tempVect(1:k)]; 
totalNoTerms = 1+k; 
sortTempVect = sort(tempVect);
maxPower = sortTempVect(totalNoTerms);
tPowerAndTheirLog = [sortTempVect; log(sortTempVect)]; 
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
